# Panduan Instalasi di XAMPP

Panduan lengkap untuk menginstal Sistem TTD SMAN 1 Tanjungbalai di XAMPP.

## 📋 Persyaratan

- XAMPP 7.4+ (PHP 7.4+, MySQL 5.7+, Apache)
- Browser modern (Chrome, Firefox, Safari, Edge)
- Koneksi internet untuk QR Code generation

## 🔧 Langkah Instalasi

### 1. Persiapan XAMPP

1. **Download dan Install XAMPP**
   - Download dari: https://www.apachefriends.org/
   - Install dengan default settings
   - Pastikan PHP dan MySQL terinstall

2. **Start Services**
   - Buka XAMPP Control Panel
   - Start **Apache** dan **MySQL**
   - Pastikan status "Running" berwarna hijau

### 2. Setup Database

1. **Akses phpMyAdmin**
   - Buka browser: `http://localhost/phpmyadmin`
   - Login dengan user: `root`, password: (kosong)

2. **Buat Database**
   ```sql
   CREATE DATABASE ttd_sman1;
   ```

3. **Import Schema**
   - Pilih database `ttd_sman1`
   - Tab "Import"
   - Choose file: `database/schema.sql`
   - Klik "Go"

### 3. Install Aplikasi

1. **Copy Files**
   ```
   # Copy folder ttd_sman1 ke:
   C:\xampp\htdocs\ttd_sman1\
   ```

2. **Set Permissions** (Windows)
   - Klik kanan folder `uploads` → Properties → Security
   - Edit → Add → Everyone → Full Control
   - Apply ke semua subfolder

3. **Konfigurasi Database**
   - Edit file: `config/database.php`
   ```php
   define('DB_HOST', 'localhost');
   define('DB_NAME', 'ttd_sman1');
   define('DB_USER', 'root');
   define('DB_PASS', ''); // Kosong untuk XAMPP default
   ```

### 4. Testing Aplikasi

1. **Akses Aplikasi**
   - Buka browser: `http://localhost/ttd_sman1/public`
   - Atau: `http://localhost/ttd_sman1/public/login.php`

2. **Login Test**
   - **Administrator**:
     - Username: `administrator`
     - Password: `password`
   - **Kepala Sekolah**:
     - Username: `kepala_sekolah`
     - Password: `password`

## 🔧 Konfigurasi Tambahan

### Enable URL Rewriting (Opsional)

1. **Edit httpd.conf**
   - File: `C:\xampp\apache\conf\httpd.conf`
   - Uncomment: `LoadModule rewrite_module modules/mod_rewrite.so`

2. **Restart Apache**
   - XAMPP Control Panel → Apache → Stop → Start

### PHP Configuration

1. **Edit php.ini**
   - File: `C:\xampp\php\php.ini`
   - Set:
   ```ini
   upload_max_filesize = 10M
   post_max_size = 10M
   max_execution_time = 300
   memory_limit = 256M
   extension=gd
   ```

2. **Restart Apache**

### Virtual Host (Opsional)

1. **Edit httpd-vhosts.conf**
   - File: `C:\xampp\apache\conf\extra\httpd-vhosts.conf`
   - Tambahkan:
   ```apache
   <VirtualHost *:80>
       ServerName ttd-sman1.local
       DocumentRoot "C:/xampp/htdocs/ttd_sman1/public"
       <Directory "C:/xampp/htdocs/ttd_sman1/public">
           AllowOverride All
           Require all granted
       </Directory>
   </VirtualHost>
   ```

2. **Edit hosts file**
   - File: `C:\Windows\System32\drivers\etc\hosts`
   - Tambahkan: `127.0.0.1 ttd-sman1.local`

3. **Akses**: `http://ttd-sman1.local`

## 🐛 Troubleshooting XAMPP

### Apache Tidak Start

**Error: Port 80 sudah digunakan**
```
1. XAMPP Control Panel → Apache → Config → httpd.conf
2. Cari: Listen 80
3. Ganti: Listen 8080
4. Akses: http://localhost:8080/ttd_sman1/public
```

**Error: Port 443 sudah digunakan**
```
1. XAMPP Control Panel → Apache → Config → httpd-ssl.conf
2. Cari: Listen 443
3. Ganti: Listen 4433
```

### MySQL Tidak Start

**Error: Port 3306 sudah digunakan**
```
1. XAMPP Control Panel → MySQL → Config → my.ini
2. Cari: port=3306
3. Ganti: port=3307
4. Update config/database.php:
   define('DB_HOST', 'localhost:3307');
```

### File Upload Error

**Error: File terlalu besar**
```
1. Edit C:\xampp\php\php.ini:
   upload_max_filesize = 20M
   post_max_size = 20M
2. Restart Apache
```

**Error: Permission denied**
```
1. Klik kanan folder uploads
2. Properties → Security → Edit
3. Add → Everyone → Full Control
```

### Database Connection Error

**Error: Access denied**
```
1. phpMyAdmin → User accounts
2. Add user account:
   - Username: ttd_user
   - Password: ttd_password
   - Host: localhost
3. Grant all privileges on ttd_sman1.*
4. Update config/database.php
```

### QR Code Generation Error

**Error: QR Code tidak muncul**
```
1. Check internet connection
2. Test: https://api.qrserver.com/v1/create-qr-code/?data=test
3. Check PHP GD extension:
   - phpinfo() → search "gd"
   - Jika tidak ada, uncomment extension=gd di php.ini
```

## 📁 Struktur Folder XAMPP

```
C:\xampp\htdocs\ttd_sman1\
├── app/
├── config/
├── database/
├── public/          # Web root
├── resources/
├── uploads/         # Pastikan writable
│   ├── documents/
│   ├── qr_codes/
│   └── profiles/
└── README.md
```

## 🔒 Keamanan di XAMPP

### Production Settings

**Jangan gunakan untuk production!** XAMPP hanya untuk development.

Untuk production:
1. Ganti password MySQL root
2. Disable phpMyAdmin public access
3. Enable SSL/HTTPS
4. Set proper file permissions
5. Update default passwords aplikasi

### Development Security

```php
// config/database.php - Development only
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', ''); // XAMPP default

// Untuk production, gunakan:
// define('DB_USER', 'ttd_user');
// define('DB_PASS', 'strong_password');
```

## 📞 Support XAMPP

### Resources
- **XAMPP Documentation**: https://www.apachefriends.org/docs/
- **PHP Manual**: https://www.php.net/manual/
- **MySQL Documentation**: https://dev.mysql.com/doc/

### Common URLs
- **XAMPP Dashboard**: http://localhost/dashboard/
- **phpMyAdmin**: http://localhost/phpmyadmin/
- **Aplikasi TTD**: http://localhost/ttd_sman1/public/

---

**Catatan**: Panduan ini khusus untuk environment development dengan XAMPP. Untuk deployment production, gunakan web server yang proper dengan konfigurasi keamanan yang sesuai.

