# Sistem Penandatanganan Digital SMAN 1 Tanjungbalai

Aplikasi web untuk penandatanganan surat dan sertifikat digital dengan sistem persetujuan berlapis dan verifikasi QR Code.

## 🚀 Fitur Utama

### 👥 Manajemen Pengguna
- **Dua Role Pengguna:**
  - **Administrator**: Membuat dan mengelola surat
  - **Kepala Sekolah**: Menyetujui atau menolak surat
- **Sistem Autentikasi** dengan session management
- **Profil Pengguna** dengan foto dan informasi lengkap

### 📄 Manajemen Surat
- **Buat Surat Baru** dengan upload file (PDF, DOC, DOCX)
- **Edit Surat** yang masih menunggu persetujuan
- **Tracking Status** (Menunggu, Disetujui, Ditolak)
- **Riwayat Persetujuan** dengan log aktivitas

### ✅ Sistem Persetujuan
- **Workflow Persetujuan** dari Administrator ke Kepala Sekolah
- **Approve/Reject** dengan catatan dan alasan
- **Notifikasi Status** real-time

### 🔐 Verifikasi Digital
- **QR Code Generator** otomatis untuk surat yang disetujui
- **Logo Pemprovsu** terintegrasi di tengah QR Code
- **Halaman Verifikasi Publik** untuk cek keaslian surat
- **Download QR Code** dalam format JPG/PNG

### 📱 Responsive Design
- **Bootstrap 5** untuk tampilan modern
- **Mobile-First** design approach
- **Sidebar Collapsible** untuk navigasi mobile
- **Touch-Friendly** interface

## 🛠️ Teknologi

- **Backend**: PHP 7.4+
- **Database**: MySQL 5.7+
- **Frontend**: Bootstrap 5, Font Awesome 6
- **QR Code**: QR Server API dengan logo overlay
- **Server**: Apache/Nginx dengan mod_rewrite

## 📋 Persyaratan Sistem

### Server Requirements
- PHP 7.4 atau lebih tinggi
- MySQL 5.7 atau MariaDB 10.2+
- Apache/Nginx dengan mod_rewrite
- GD Extension untuk manipulasi gambar
- PDO MySQL Extension

### Recommended
- PHP 8.0+
- MySQL 8.0+
- SSL Certificate untuk HTTPS
- Minimum 512MB RAM
- 1GB Storage space

## 🔧 Instalasi

### 1. Download dan Extract
```bash
# Download aplikasi
git clone [repository-url] ttd_sman1
cd ttd_sman1
```

### 2. Setup Database
```bash
# Buat database
mysql -u root -p
CREATE DATABASE ttd_sman1;
exit

# Import schema
mysql -u root -p ttd_sman1 < database/schema.sql
```

### 3. Konfigurasi
```bash
# Edit konfigurasi database
nano config/database.php

# Sesuaikan:
define('DB_HOST', 'localhost');
define('DB_NAME', 'ttd_sman1');
define('DB_USER', 'your_username');
define('DB_PASS', 'your_password');
```

### 4. Set Permissions
```bash
# Set permission untuk upload folders
chmod 755 uploads/
chmod 755 uploads/documents/
chmod 755 uploads/qr_codes/
chmod 755 uploads/profiles/

# Set permission untuk web server
chown -R www-data:www-data .
```

### 5. Virtual Host (Apache)
```apache
<VirtualHost *:80>
    ServerName ttd-sman1.local
    DocumentRoot /path/to/ttd_sman1/public
    
    <Directory /path/to/ttd_sman1/public>
        AllowOverride All
        Require all granted
    </Directory>
    
    ErrorLog ${APACHE_LOG_DIR}/ttd_sman1_error.log
    CustomLog ${APACHE_LOG_DIR}/ttd_sman1_access.log combined
</VirtualHost>
```

### 6. Virtual Host (Nginx)
```nginx
server {
    listen 80;
    server_name ttd-sman1.local;
    root /path/to/ttd_sman1/public;
    index index.php;

    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }

    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.0-fpm.sock;
        fastcgi_index index.php;
        fastcgi_param SCRIPT_FILENAME $realpath_root$fastcgi_script_name;
        include fastcgi_params;
    }
}
```

## 👤 Default Users

### Kepala Sekolah
- **Username**: `kepala_sekolah`
- **Password**: `password`
- **Email**: anshari73@gmail.com
- **Nama**: Deddi Anshari, S.Pd, M.Si

### Administrator
- **Username**: `administrator`
- **Password**: `password`
- **Email**: t.rifaldosany@gmail.com
- **Nama**: T. Rifaldo Sany

> ⚠️ **Penting**: Ubah password default setelah instalasi!

## 📖 Panduan Penggunaan

### Untuk Administrator
1. **Login** dengan akun administrator
2. **Buat Surat Baru** melalui menu "Buat Surat"
3. **Upload File** surat (PDF/DOC/DOCX)
4. **Isi Informasi** judul, perihal, dan deskripsi
5. **Kirim** untuk persetujuan Kepala Sekolah
6. **Monitor Status** di menu "Kelola Surat"

### Untuk Kepala Sekolah
1. **Login** dengan akun kepala sekolah
2. **Lihat Surat** yang menunggu persetujuan
3. **Review** detail surat dan file
4. **Approve/Reject** dengan catatan
5. **QR Code** otomatis dibuat untuk surat yang disetujui

### Verifikasi Publik
1. **Akses** halaman `/verify.php`
2. **Masukkan** nomor surat
3. **Lihat** status dan detail verifikasi
4. **Scan QR Code** untuk verifikasi mobile

## 🔒 Keamanan

### Fitur Keamanan
- **Password Hashing** dengan bcrypt
- **CSRF Protection** untuk form
- **Session Timeout** otomatis
- **File Upload Validation** dengan whitelist
- **SQL Injection Protection** dengan prepared statements
- **XSS Protection** dengan input sanitization

### Security Headers
```apache
Header always set X-Content-Type-Options nosniff
Header always set X-Frame-Options DENY
Header always set X-XSS-Protection "1; mode=block"
Header always set Referrer-Policy "strict-origin-when-cross-origin"
```

## 📁 Struktur Folder

```
ttd_sman1/
├── app/                    # Core application files
│   ├── auth.php           # Authentication class
│   └── qrcode.php         # QR Code generator
├── config/                # Configuration files
│   └── database.php       # Database configuration
├── database/              # Database files
│   └── schema.sql         # Database schema
├── public/                # Web accessible files
│   ├── *.php             # Application pages
│   └── .htaccess         # Apache configuration
├── resources/             # Shared resources
│   ├── header.php        # Header template
│   └── footer.php        # Footer template
├── uploads/               # Upload directories
│   ├── documents/        # Document files
│   ├── qr_codes/         # QR Code images
│   └── profiles/         # Profile photos
└── README.md             # This file
```

## 🐛 Troubleshooting

### Database Connection Error
```bash
# Check database credentials
nano config/database.php

# Test database connection
mysql -u username -p database_name
```

### File Upload Issues
```bash
# Check PHP upload settings
php -i | grep upload

# Check folder permissions
ls -la uploads/
```

### QR Code Generation Failed
```bash
# Check internet connection (uses external API)
curl -I https://api.qrserver.com

# Check GD extension
php -m | grep -i gd
```

### Apache Rewrite Issues
```bash
# Enable mod_rewrite
sudo a2enmod rewrite
sudo systemctl restart apache2

# Check .htaccess permissions
ls -la public/.htaccess
```

## 🔄 Update & Maintenance

### Backup Database
```bash
mysqldump -u username -p ttd_sman1 > backup_$(date +%Y%m%d).sql
```

### Update Application
```bash
# Backup current installation
cp -r ttd_sman1 ttd_sman1_backup

# Update files (preserve config and uploads)
# Run database migrations if any
```

### Log Monitoring
```bash
# Check Apache logs
tail -f /var/log/apache2/ttd_sman1_error.log

# Check PHP errors
tail -f /var/log/php_errors.log
```

## 📞 Support

### Developer Information
- **Nama**: T. Rifaldo Sany
- **Jabatan**: Pustakawan Junior SMAN 1 Tanjungbalai
- **Email**: t.rifaldosany@gmail.com
- **Telepon**: +62 857-6777-6154

### Institusi
- **Sekolah**: SMAN 1 Tanjungbalai
- **Alamat**: Tanjungbalai, Sumatera Utara
- **Website**: [sman1tanjungbalai.sch.id]

## 📄 License

Copyright © 2025 SMAN 1 Tanjungbalai. All rights reserved.

Aplikasi ini dikembangkan khusus untuk SMAN 1 Tanjungbalai dan tidak untuk distribusi komersial.

---

**Dikembangkan dengan ❤️ oleh T. Rifaldo Sany**  
*Pustakawan Junior SMAN 1 Tanjungbalai*

