# User Manual - Sistem TTD SMAN 1 Tanjungbalai

Panduan lengkap penggunaan Sistem Penandatanganan Digital SMAN 1 Tanjungbalai.

## 📖 Daftar Isi

1. [Pengenalan Sistem](#pengenalan-sistem)
2. [Login dan Logout](#login-dan-logout)
3. [Dashboard](#dashboard)
4. [Untuk Administrator](#untuk-administrator)
5. [Untuk Kepala Sekolah](#untuk-kepala-sekolah)
6. [Verifikasi Publik](#verifikasi-publik)
7. [Profil Pengguna](#profil-pengguna)
8. [FAQ](#faq)

## 🎯 Pengenalan Sistem

### Tujuan Aplikasi
Sistem TTD SMAN 1 Tanjungbalai adalah aplikasi web untuk mengelola penandatanganan surat dan sertifikat digital dengan sistem persetujuan berlapis dan verifikasi QR Code.

### Fitur Utama
- ✅ Manajemen surat digital
- ✅ Sistem persetujuan berlapis
- ✅ QR Code untuk verifikasi
- ✅ Dashboard informatif
- ✅ Responsive design

### Role Pengguna
1. **Administrator**: Membuat dan mengelola surat
2. **Kepala Sekolah**: Menyetujui atau menolak surat

## 🔐 Login dan Logout

### Cara Login
1. **Akses Halaman Login**
   - Buka aplikasi di browser
   - Otomatis diarahkan ke halaman login

2. **Masukkan Kredensial**
   - Username: sesuai akun yang diberikan
   - Password: sesuai akun yang diberikan

3. **Klik Tombol Login**
   - Sistem akan memverifikasi kredensial
   - Jika berhasil, diarahkan ke dashboard

### Akun Default
**Administrator:**
- Username: `administrator`
- Password: `password`

**Kepala Sekolah:**
- Username: `kepala_sekolah`
- Password: `password`

> ⚠️ **Penting**: Ubah password default setelah login pertama!

### Cara Logout
1. Klik nama pengguna di pojok kanan atas
2. Pilih "Logout" dari dropdown menu
3. Sistem akan mengakhiri sesi dan kembali ke halaman login

## 📊 Dashboard

### Tampilan Dashboard
Dashboard menampilkan informasi ringkasan dan akses cepat ke fitur utama.

#### Statistik Surat
- **Total Surat**: Jumlah keseluruhan surat
- **Menunggu**: Surat yang belum disetujui
- **Disetujui**: Surat yang sudah disetujui
- **Ditolak**: Surat yang ditolak

#### Card Profil
- Foto profil pengguna
- Informasi personal lengkap
- Data kontak

#### Surat Terbaru
- Daftar 5 surat terbaru
- Status masing-masing surat
- Link ke detail surat

#### Aksi Cepat
- Tombol untuk akses fitur utama
- Disesuaikan dengan role pengguna

## 👨‍💼 Untuk Administrator

### 1. Membuat Surat Baru

#### Langkah-langkah:
1. **Akses Menu Buat Surat**
   - Dashboard → "Buat Surat Baru"
   - Atau Sidebar → "Buat Surat"

2. **Isi Informasi Surat**
   - **Judul Surat**: Masukkan judul yang jelas
   - **Perihal**: Isi perihal/subjek surat
   - **Deskripsi**: Tambahkan keterangan (opsional)

3. **Upload File Surat**
   - Klik "Choose File"
   - Pilih file surat (PDF, DOC, DOCX)
   - Maksimal 10MB

4. **Kirim Surat**
   - Klik "Kirim Surat"
   - Sistem akan generate nomor surat otomatis
   - Status: "Menunggu Persetujuan"

#### Tips:
- Gunakan format PDF untuk hasil terbaik
- Pastikan file dapat dibaca dengan jelas
- Isi deskripsi untuk informasi tambahan

### 2. Mengelola Surat

#### Akses Menu Kelola Surat
- Dashboard → "Kelola Surat"
- Atau Sidebar → "Kelola Surat"

#### Fitur Pencarian
- **Cari berdasarkan**: Judul, nomor surat, perihal
- **Filter status**: Semua, Menunggu, Disetujui, Ditolak
- **Pagination**: Navigasi halaman untuk banyak data

#### Aksi pada Surat
- **👁️ Lihat**: Melihat detail lengkap surat
- **✏️ Edit**: Edit surat yang masih menunggu
- **📥 Download**: Download file surat
- **🗑️ Hapus**: Hapus surat yang masih menunggu
- **📱 QR Code**: Download QR Code (jika disetujui)

### 3. Edit Surat

#### Kapan Bisa Edit?
- Hanya surat dengan status "Menunggu"
- Setelah disetujui/ditolak tidak bisa diedit

#### Yang Bisa Diedit:
- Judul surat
- Perihal surat
- Deskripsi
- File surat (opsional)

#### Yang Tidak Bisa Diedit:
- Nomor surat
- Tanggal pembuatan
- Status surat

#### Langkah Edit:
1. Buka detail surat
2. Klik tombol "Edit"
3. Ubah informasi yang diperlukan
4. Upload file baru (jika perlu)
5. Klik "Simpan Perubahan"

### 4. Monitoring Status

#### Status Surat:
- **🟡 Menunggu**: Belum ditinjau Kepala Sekolah
- **🟢 Disetujui**: Sudah disetujui dan ditandatangani
- **🔴 Ditolak**: Ditolak dengan alasan tertentu

#### Riwayat Persetujuan:
- Log semua aktivitas surat
- Waktu dan pelaku aksi
- Catatan dari approver

## 👨‍🎓 Untuk Kepala Sekolah

### 1. Meninjau Surat

#### Akses Menu Persetujuan
- Dashboard → "Persetujuan Surat"
- Atau Sidebar → "Persetujuan"

#### Informasi Surat
- Detail lengkap surat
- Informasi pembuat surat
- File surat untuk review
- Riwayat aktivitas

### 2. Menyetujui Surat

#### Langkah Persetujuan:
1. **Buka Detail Surat**
   - Klik "Lihat Detail" pada surat
   - Review informasi dan file

2. **Klik Tombol Setujui**
   - Tombol hijau dengan ikon ✅
   - Muncul dialog konfirmasi

3. **Isi Catatan (Opsional)**
   - Tambahkan catatan persetujuan
   - Klik "Setujui Surat"

#### Hasil Persetujuan:
- Status berubah menjadi "Disetujui"
- QR Code otomatis dibuat
- Surat dapat diverifikasi publik

### 3. Menolak Surat

#### Langkah Penolakan:
1. **Klik Tombol Tolak**
   - Tombol merah dengan ikon ❌
   - Muncul dialog konfirmasi

2. **Isi Alasan Penolakan**
   - **Wajib diisi**: Jelaskan alasan penolakan
   - Tambahkan catatan tambahan (opsional)

3. **Konfirmasi Penolakan**
   - Klik "Tolak Surat"
   - Status berubah menjadi "Ditolak"

#### Hasil Penolakan:
- Administrator dapat melihat alasan
- Surat tidak dapat diverifikasi
- Administrator bisa buat surat baru

### 4. Statistik dan Laporan

#### Dashboard Kepala Sekolah
- Total surat masuk
- Surat menunggu persetujuan
- Surat yang sudah disetujui
- Surat yang ditolak

#### Filter dan Pencarian
- Cari surat berdasarkan kriteria
- Filter berdasarkan status
- Urutkan berdasarkan tanggal

## 🔍 Verifikasi Publik

### Akses Halaman Verifikasi
- URL: `/verify.php`
- Dapat diakses tanpa login
- Untuk verifikasi keaslian surat

### Cara Verifikasi

#### Metode 1: Input Manual
1. Buka halaman verifikasi
2. Masukkan nomor surat
3. Klik "Verifikasi"
4. Lihat hasil verifikasi

#### Metode 2: Scan QR Code
1. Scan QR Code dengan smartphone
2. Otomatis membuka halaman verifikasi
3. Lihat detail surat yang terverifikasi

### Informasi Verifikasi
- Status dokumen (Valid/Tidak Valid)
- Detail surat lengkap
- Informasi pembuat dan approver
- Tanggal pembuatan dan persetujuan
- Waktu verifikasi

## 👤 Profil Pengguna

### Mengelola Profil

#### Akses Profil
- Sidebar → "Profil"
- Atau klik nama pengguna → "Profil"

#### Edit Informasi
1. **Data Personal**
   - Nama lengkap
   - Email
   - NIP
   - Tempat, tanggal lahir
   - Pendidikan terakhir
   - Jabatan
   - Telepon
   - Alamat

2. **Foto Profil**
   - Upload foto (JPG, PNG)
   - Ukuran maksimal 2MB
   - Rasio 1:1 (persegi)

3. **Ubah Password**
   - Password lama
   - Password baru (minimal 6 karakter)
   - Konfirmasi password baru

### Tips Profil
- Gunakan foto formal untuk profil
- Pastikan informasi kontak akurat
- Ubah password secara berkala
- Simpan perubahan setelah edit

## ❓ FAQ (Frequently Asked Questions)

### Umum

**Q: Bagaimana cara mengakses aplikasi?**
A: Buka browser dan akses URL aplikasi yang diberikan admin sistem.

**Q: Lupa password, bagaimana?**
A: Hubungi administrator sistem untuk reset password.

**Q: Aplikasi tidak bisa diakses?**
A: Pastikan koneksi internet stabil dan server aplikasi berjalan.

### Untuk Administrator

**Q: Format file apa saja yang didukung?**
A: PDF, DOC, dan DOCX dengan maksimal 10MB.

**Q: Bisakah edit surat yang sudah disetujui?**
A: Tidak, hanya surat dengan status "Menunggu" yang bisa diedit.

**Q: Bagaimana cara download QR Code?**
A: Setelah surat disetujui, klik tombol QR Code di daftar surat.

**Q: Nomor surat bisa diubah?**
A: Tidak, nomor surat otomatis dan tidak bisa diubah.

### Untuk Kepala Sekolah

**Q: Harus isi alasan saat menolak surat?**
A: Ya, alasan penolakan wajib diisi untuk transparansi.

**Q: Bisakah batalkan persetujuan yang sudah diberikan?**
A: Tidak, keputusan persetujuan bersifat final.

**Q: Bagaimana cara lihat riwayat persetujuan?**
A: Buka detail surat, di sisi kanan ada panel "Riwayat Persetujuan".

### Verifikasi

**Q: QR Code tidak bisa discan?**
A: Pastikan QR Code jelas dan gunakan aplikasi scanner yang baik.

**Q: Verifikasi menunjukkan "Tidak Ditemukan"?**
A: Periksa nomor surat atau surat belum disetujui.

**Q: Bisakah verifikasi tanpa internet?**
A: Tidak, verifikasi memerlukan koneksi internet.

### Teknis

**Q: Browser apa yang didukung?**
A: Chrome, Firefox, Safari, Edge versi terbaru.

**Q: Aplikasi bisa diakses di mobile?**
A: Ya, aplikasi responsive dan mobile-friendly.

**Q: Data aman?**
A: Ya, menggunakan enkripsi dan sistem keamanan berlapis.

## 📞 Bantuan dan Support

### Kontak Developer
- **Nama**: T. Rifaldo Sany
- **Jabatan**: Pustakawan Junior SMAN 1 Tanjungbalai
- **Email**: t.rifaldosany@gmail.com
- **Telepon**: +62 857-6777-6154

### Kontak Sekolah
- **Sekolah**: SMAN 1 Tanjungbalai
- **Alamat**: Tanjungbalai, Sumatera Utara

### Pelaporan Bug
Jika menemukan bug atau error:
1. Screenshot halaman error
2. Jelaskan langkah yang dilakukan
3. Kirim ke email developer
4. Sertakan informasi browser dan device

---

**Terima kasih telah menggunakan Sistem TTD SMAN 1 Tanjungbalai!**

*Dikembangkan dengan ❤️ oleh T. Rifaldo Sany*

