<?php
/**
 * Dashboard Page
 * Aplikasi TTD SMAN 1 Tanjungbalai
 * Developer: T. Rifaldo Sany
 */

require_once '../config/database.php';
require_once '../app/auth.php';

$auth = new Auth();
$auth->requireLogin();

$user = $auth->getCurrentUser();
$db = getDB();

// Get statistics
$stats = [];

if ($_SESSION['role'] == 'administrator') {
    // Statistics for Administrator
    $stmt = $db->prepare("SELECT 
        COUNT(*) as total_documents,
        SUM(CASE WHEN status = 'pending' THEN 1 ELSE 0 END) as pending_documents,
        SUM(CASE WHEN status = 'approved' THEN 1 ELSE 0 END) as approved_documents,
        SUM(CASE WHEN status = 'rejected' THEN 1 ELSE 0 END) as rejected_documents
        FROM documents WHERE created_by = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $stats = $stmt->fetch();
} else {
    // Statistics for Kepala Sekolah
    $stmt = $db->prepare("SELECT 
        COUNT(*) as total_documents,
        SUM(CASE WHEN status = 'pending' THEN 1 ELSE 0 END) as pending_documents,
        SUM(CASE WHEN status = 'approved' THEN 1 ELSE 0 END) as approved_documents,
        SUM(CASE WHEN status = 'rejected' THEN 1 ELSE 0 END) as rejected_documents
        FROM documents");
    $stmt->execute();
    $stats = $stmt->fetch();
}

// Get recent documents
$recentDocuments = [];
if ($_SESSION['role'] == 'administrator') {
    $stmt = $db->prepare("SELECT * FROM documents WHERE created_by = ? ORDER BY created_at DESC LIMIT 5");
    $stmt->execute([$_SESSION['user_id']]);
} else {
    $stmt = $db->prepare("SELECT d.*, u.full_name as creator_name FROM documents d 
                         JOIN users u ON d.created_by = u.id 
                         WHERE d.status = 'pending' 
                         ORDER BY d.created_at DESC LIMIT 5");
    $stmt->execute();
}
$recentDocuments = $stmt->fetchAll();

$title = 'Dashboard - SMAN 1 Tanjungbalai';
$showNavbar = true;
$showSidebar = true;

include '../resources/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h1 class="h3 mb-0 fw-bold">Dashboard</h1>
        <p class="text-muted mb-0">Selamat datang, <?php echo $user['full_name']; ?>!</p>
    </div>
    <div class="text-end">
        <small class="text-muted">
            <i class="fas fa-clock me-1"></i>
            <?php echo date('d F Y, H:i'); ?>
        </small>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="card-title mb-0">Total Surat</h6>
                        <h2 class="mb-0"><?php echo $stats['total_documents']; ?></h2>
                    </div>
                    <div class="opacity-75">
                        <i class="fas fa-file-alt fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="card-title mb-0">Menunggu</h6>
                        <h2 class="mb-0"><?php echo $stats['pending_documents']; ?></h2>
                    </div>
                    <div class="opacity-75">
                        <i class="fas fa-clock fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="card-title mb-0">Disetujui</h6>
                        <h2 class="mb-0"><?php echo $stats['approved_documents']; ?></h2>
                    </div>
                    <div class="opacity-75">
                        <i class="fas fa-check-circle fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card bg-danger text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="card-title mb-0">Ditolak</h6>
                        <h2 class="mb-0"><?php echo $stats['rejected_documents']; ?></h2>
                    </div>
                    <div class="opacity-75">
                        <i class="fas fa-times-circle fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Profile Card -->
    <div class="col-lg-4 mb-4">
        <div class="card profile-card h-100">
            <div class="card-body text-center">
                <div class="mb-3">
                    <?php if ($user['profile_photo']): ?>
                        <img src="../uploads/profiles/<?php echo $user['profile_photo']; ?>" 
                             alt="Profile" class="rounded-circle profile-img">
                    <?php else: ?>
                        <div class="rounded-circle profile-img bg-white d-flex align-items-center justify-content-center mx-auto">
                            <i class="fas fa-user fa-3x text-muted"></i>
                        </div>
                    <?php endif; ?>
                </div>
                
                <h5 class="card-title fw-bold"><?php echo $user['full_name']; ?></h5>
                <p class="mb-2"><?php echo $user['position']; ?></p>
                
                <?php if ($user['nip']): ?>
                <p class="mb-3"><small>NIP: <?php echo $user['nip']; ?></small></p>
                <?php endif; ?>
                
                <div class="row text-start">
                    <div class="col-12 mb-2">
                        <small class="opacity-75">Tempat, Tanggal Lahir:</small><br>
                        <span><?php echo $user['birth_place'] . ', ' . date('d F Y', strtotime($user['birth_date'])); ?></span>
                    </div>
                    
                    <div class="col-12 mb-2">
                        <small class="opacity-75">Pendidikan Terakhir:</small><br>
                        <span><?php echo $user['education']; ?></span>
                    </div>
                    
                    <div class="col-12 mb-2">
                        <small class="opacity-75">Email:</small><br>
                        <span><?php echo $user['email']; ?></span>
                    </div>
                    
                    <?php if ($user['phone']): ?>
                    <div class="col-12 mb-2">
                        <small class="opacity-75">Telepon:</small><br>
                        <span><?php echo $user['phone']; ?></span>
                    </div>
                    <?php endif; ?>
                    
                    <?php if ($user['address']): ?>
                    <div class="col-12">
                        <small class="opacity-75">Alamat:</small><br>
                        <span><?php echo $user['address']; ?></span>
                    </div>
                    <?php endif; ?>
                </div>
                
                <div class="mt-3">
                    <a href="profile.php" class="btn btn-light btn-sm">
                        <i class="fas fa-edit me-1"></i>Edit Profil
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Recent Documents -->
    <div class="col-lg-8 mb-4">
        <div class="card h-100">
            <div class="card-header bg-white">
                <div class="d-flex justify-content-between align-items-center">
                    <h6 class="mb-0 fw-bold">
                        <?php echo $_SESSION['role'] == 'administrator' ? 'Surat Terbaru Saya' : 'Surat Menunggu Persetujuan'; ?>
                    </h6>
                    <?php if ($_SESSION['role'] == 'administrator'): ?>
                        <a href="documents.php" class="btn btn-sm btn-outline-primary">Lihat Semua</a>
                    <?php else: ?>
                        <a href="approvals.php" class="btn btn-sm btn-outline-primary">Lihat Semua</a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="card-body">
                <?php if (empty($recentDocuments)): ?>
                    <div class="text-center py-4">
                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                        <p class="text-muted">Belum ada surat</p>
                    </div>
                <?php else: ?>
                    <div class="list-group list-group-flush">
                        <?php foreach ($recentDocuments as $doc): ?>
                            <div class="list-group-item border-0 px-0">
                                <div class="d-flex justify-content-between align-items-start">
                                    <div class="flex-grow-1">
                                        <h6 class="mb-1"><?php echo $doc['title']; ?></h6>
                                        <p class="mb-1 text-muted small"><?php echo $doc['document_number']; ?></p>
                                        <?php if (isset($doc['creator_name'])): ?>
                                            <small class="text-muted">Dibuat oleh: <?php echo $doc['creator_name']; ?></small>
                                        <?php endif; ?>
                                    </div>
                                    <div class="text-end">
                                        <span class="status-badge status-<?php echo $doc['status']; ?>">
                                            <?php 
                                            switch($doc['status']) {
                                                case 'pending': echo 'Menunggu'; break;
                                                case 'approved': echo 'Disetujui'; break;
                                                case 'rejected': echo 'Ditolak'; break;
                                            }
                                            ?>
                                        </span>
                                        <br>
                                        <small class="text-muted"><?php echo date('d/m/Y', strtotime($doc['created_at'])); ?></small>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header bg-white">
                <h6 class="mb-0 fw-bold">Aksi Cepat</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php if ($_SESSION['role'] == 'administrator'): ?>
                        <div class="col-lg-3 col-md-6 mb-3">
                            <a href="create_document.php" class="btn btn-outline-primary w-100 h-100 d-flex flex-column align-items-center justify-content-center py-3">
                                <i class="fas fa-plus-circle fa-2x mb-2"></i>
                                <span>Buat Surat Baru</span>
                            </a>
                        </div>
                        <div class="col-lg-3 col-md-6 mb-3">
                            <a href="documents.php" class="btn btn-outline-success w-100 h-100 d-flex flex-column align-items-center justify-content-center py-3">
                                <i class="fas fa-file-alt fa-2x mb-2"></i>
                                <span>Kelola Surat</span>
                            </a>
                        </div>
                    <?php else: ?>
                        <div class="col-lg-3 col-md-6 mb-3">
                            <a href="approvals.php" class="btn btn-outline-warning w-100 h-100 d-flex flex-column align-items-center justify-content-center py-3">
                                <i class="fas fa-check-circle fa-2x mb-2"></i>
                                <span>Persetujuan Surat</span>
                            </a>
                        </div>
                    <?php endif; ?>
                    
                    <div class="col-lg-3 col-md-6 mb-3">
                        <a href="profile.php" class="btn btn-outline-info w-100 h-100 d-flex flex-column align-items-center justify-content-center py-3">
                            <i class="fas fa-user fa-2x mb-2"></i>
                            <span>Edit Profil</span>
                        </a>
                    </div>
                    
                    <div class="col-lg-3 col-md-6 mb-3">
                        <a href="#" onclick="window.print()" class="btn btn-outline-secondary w-100 h-100 d-flex flex-column align-items-center justify-content-center py-3">
                            <i class="fas fa-print fa-2x mb-2"></i>
                            <span>Cetak Laporan</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../resources/footer.php'; ?>

