<?php
/**
 * Generate QR Code Page
 * Aplikasi TTD SMAN 1 Tanjungbalai
 * Developer: T. Rifaldo Sany
 */

require_once '../config/database.php';
require_once '../app/auth.php';
require_once '../app/qrcode.php';

$auth = new Auth();
$auth->requireLogin();

$error = '';
$success = '';
$qrCodePath = '';

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    $error = 'ID dokumen tidak valid!';
} else {
    $documentId = $_GET['id'];
    $db = getDB();
    
    try {
        // Check if document exists and is approved
        $stmt = $db->prepare("SELECT * FROM documents WHERE id = ? AND status = 'approved'");
        $stmt->execute([$documentId]);
        $document = $stmt->fetch();
        
        if (!$document) {
            $error = 'Dokumen tidak ditemukan atau belum disetujui!';
        } elseif ($_SESSION['role'] === 'administrator' && $document['created_by'] != $_SESSION['user_id']) {
            $error = 'Anda tidak memiliki akses ke dokumen ini!';
        } else {
            // Generate QR Code
            $qrGenerator = new QRCodeGenerator();
            $qrCodeFilename = $qrGenerator->generateQRCode($documentId);
            
            if ($qrCodeFilename) {
                $success = 'QR Code berhasil dibuat!';
                $qrCodePath = '../uploads/qr_codes/' . $qrCodeFilename;
            } else {
                $error = 'Gagal membuat QR Code!';
            }
        }
    } catch (PDOException $e) {
        $error = 'Terjadi kesalahan database!';
        error_log("Generate QR error: " . $e->getMessage());
    }
}

$title = 'Generate QR Code - SMAN 1 Tanjungbalai';
$showNavbar = true;
$showSidebar = true;

include '../resources/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h1 class="h3 mb-0 fw-bold">Generate QR Code</h1>
        <p class="text-muted mb-0">Buat QR Code untuk verifikasi dokumen</p>
    </div>
    <a href="<?php echo $_SESSION['role'] === 'administrator' ? 'documents.php' : 'approvals.php'; ?>" class="btn btn-outline-secondary">
        <i class="fas fa-arrow-left me-1"></i>Kembali
    </a>
</div>

<?php if ($error): ?>
    <div class="alert alert-danger" role="alert">
        <i class="fas fa-exclamation-triangle me-2"></i><?php echo $error; ?>
    </div>
<?php endif; ?>

<?php if ($success): ?>
    <div class="alert alert-success" role="alert">
        <i class="fas fa-check-circle me-2"></i><?php echo $success; ?>
    </div>
    
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-white text-center">
                    <h6 class="mb-0 fw-bold">QR Code Verifikasi</h6>
                </div>
                <div class="card-body text-center">
                    <img src="<?php echo $qrCodePath; ?>" alt="QR Code" class="img-fluid mb-3" style="max-width: 300px;">
                    
                    <div class="mb-3">
                        <p class="text-muted">Scan QR Code untuk verifikasi keaslian dokumen</p>
                        <p class="small">Dokumen: <strong><?php echo $document['document_number']; ?></strong></p>
                    </div>
                    
                    <div class="d-grid gap-2">
                        <a href="<?php echo $qrCodePath; ?>" class="btn btn-primary" download>
                            <i class="fas fa-download me-1"></i>Download QR Code (PNG)
                        </a>
                        
                        <a href="view_document.php?id=<?php echo $documentId; ?>" class="btn btn-outline-secondary">
                            <i class="fas fa-eye me-1"></i>Lihat Detail Dokumen
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php include '../resources/footer.php'; ?>

