<?php
/**
 * Login Page
 * Aplikasi TTD SMAN 1 Tanjungbalai
 * Developer: T. Rifaldo Sany
 */

require_once '../config/database.php';
require_once '../app/auth.php';

$auth = new Auth();

// Redirect if already logged in
if ($auth->isLoggedIn()) {
    redirect('dashboard.php');
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = sanitize($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if (empty($username) || empty($password)) {
        $error = 'Username dan password harus diisi!';
    } else {
        if ($auth->login($username, $password)) {
            redirect('dashboard.php');
        } else {
            $error = 'Username atau password salah!';
        }
    }
}

$title = 'Login - SMAN 1 Tanjungbalai';
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $title; ?></title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #2E7D32;
            --secondary-color: #4CAF50;
            --accent-color: #FFC107;
        }
        
        body {
            background: linear-gradient(135deg, #E8F5E8 0%, #ffffff 50%, #E8F5E8 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .login-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .login-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            overflow: hidden;
            max-width: 900px;
            width: 100%;
        }
        
        .login-left {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 60px 40px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
        }
        
        .login-right {
            padding: 60px 40px;
        }
        
        .logo-container {
            margin-bottom: 30px;
        }
        
        .logo-container img {
            width: 80px;
            height: 80px;
            margin-bottom: 20px;
        }
        
        .form-control {
            border-radius: 10px;
            border: 2px solid #e9ecef;
            padding: 12px 20px;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(46, 125, 50, 0.25);
        }
        
        .btn-login {
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            border: none;
            border-radius: 10px;
            padding: 12px 30px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(46, 125, 50, 0.3);
        }
        
        .input-group-text {
            background: transparent;
            border: 2px solid #e9ecef;
            border-right: none;
            border-radius: 10px 0 0 10px;
        }
        
        .input-group .form-control {
            border-left: none;
            border-radius: 0 10px 10px 0;
        }
        
        .alert {
            border-radius: 10px;
            border: none;
        }
        
        @media (max-width: 768px) {
            .login-left {
                padding: 40px 20px;
            }
            
            .login-right {
                padding: 40px 20px;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="login-card">
                        <div class="row g-0">
                            <!-- Left Side -->
                            <div class="col-lg-6">
                                <div class="login-left">
                                    <div class="logo-container">
                                        <img src="../uploads/logo_pemprovsu.png" alt="Logo Pemprovsu" class="img-fluid">
                                        <h3 class="fw-bold">SMAN 1 Tanjungbalai</h3>
                                        <p class="mb-0">Sistem Penandatanganan Digital</p>
                                    </div>
                                    
                                    <div class="features">
                                        <div class="feature-item mb-3">
                                            <i class="fas fa-shield-alt fa-2x mb-2"></i>
                                            <h6>Keamanan Terjamin</h6>
                                            <small>Sistem keamanan berlapis untuk melindungi dokumen</small>
                                        </div>
                                        
                                        <div class="feature-item mb-3">
                                            <i class="fas fa-mobile-alt fa-2x mb-2"></i>
                                            <h6>Responsive Design</h6>
                                            <small>Dapat diakses dari berbagai perangkat</small>
                                        </div>
                                        
                                        <div class="feature-item">
                                            <i class="fas fa-qrcode fa-2x mb-2"></i>
                                            <h6>QR Code Verification</h6>
                                            <small>Verifikasi dokumen dengan QR Code</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Right Side -->
                            <div class="col-lg-6">
                                <div class="login-right">
                                    <div class="text-center mb-4">
                                        <h2 class="fw-bold text-dark">Selamat Datang</h2>
                                        <p class="text-muted">Silakan login untuk mengakses sistem</p>
                                    </div>
                                    
                                    <?php if ($error): ?>
                                        <div class="alert alert-danger" role="alert">
                                            <i class="fas fa-exclamation-triangle me-2"></i><?php echo $error; ?>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if ($success): ?>
                                        <div class="alert alert-success" role="alert">
                                            <i class="fas fa-check-circle me-2"></i><?php echo $success; ?>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <form method="POST" class="needs-validation" novalidate>
                                        <div class="mb-3">
                                            <label for="username" class="form-label fw-semibold">Username</label>
                                            <div class="input-group">
                                                <span class="input-group-text">
                                                    <i class="fas fa-user text-muted"></i>
                                                </span>
                                                <input type="text" class="form-control" id="username" name="username" 
                                                       placeholder="Masukkan username" required>
                                                <div class="invalid-feedback">
                                                    Username harus diisi!
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="mb-4">
                                            <label for="password" class="form-label fw-semibold">Password</label>
                                            <div class="input-group">
                                                <span class="input-group-text">
                                                    <i class="fas fa-lock text-muted"></i>
                                                </span>
                                                <input type="password" class="form-control" id="password" name="password" 
                                                       placeholder="Masukkan password" required>
                                                <div class="invalid-feedback">
                                                    Password harus diisi!
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <button type="submit" class="btn btn-login btn-primary w-100 mb-3">
                                            <i class="fas fa-sign-in-alt me-2"></i>Login
                                        </button>
                                    </form>
                                    
                                    <div class="text-center">
                                        <small class="text-muted">
                                            Dikembangkan oleh <strong>T. Rifaldo Sany</strong><br>
                                            Pustakawan Junior SMAN 1 Tanjungbalai
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Form validation
        (function() {
            'use strict';
            window.addEventListener('load', function() {
                const forms = document.getElementsByClassName('needs-validation');
                Array.prototype.filter.call(forms, function(form) {
                    form.addEventListener('submit', function(event) {
                        if (form.checkValidity() === false) {
                            event.preventDefault();
                            event.stopPropagation();
                        }
                        form.classList.add('was-validated');
                    }, false);
                });
            }, false);
        })();
        
        // Auto-hide alerts
        setTimeout(function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                const bsAlert = new bootstrap.Alert(alert);
                bsAlert.close();
            });
        }, 5000);
    </script>
</body>
</html>

