<?php
/**
 * Profile Page
 * Aplikasi TTD SMAN 1 Tanjungbalai
 * Developer: T. Rifaldo Sany
 */

require_once '../config/database.php';
require_once '../app/auth.php';

$auth = new Auth();
$auth->requireLogin();

$user = $auth->getCurrentUser();
$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['update_profile'])) {
        // Update profile data
        $data = [
            'full_name' => sanitize($_POST['full_name']),
            'email' => sanitize($_POST['email']),
            'nip' => sanitize($_POST['nip']),
            'birth_place' => sanitize($_POST['birth_place']),
            'birth_date' => $_POST['birth_date'],
            'education' => sanitize($_POST['education']),
            'position' => sanitize($_POST['position']),
            'phone' => sanitize($_POST['phone']),
            'address' => sanitize($_POST['address'])
        ];
        
        if ($auth->updateProfile($data)) {
            $success = 'Profil berhasil diperbarui!';
            $user = $auth->getCurrentUser(); // Refresh user data
        } else {
            $error = 'Gagal memperbarui profil!';
        }
    }
    
    if (isset($_POST['upload_photo'])) {
        // Handle photo upload
        if (isset($_FILES['profile_photo']) && $_FILES['profile_photo']['error'] === UPLOAD_ERR_OK) {
            $file = $_FILES['profile_photo'];
            $allowedTypes = ['image/jpeg', 'image/jpg', 'image/png'];
            
            if (in_array($file['type'], $allowedTypes)) {
                $extension = pathinfo($file['name'], PATHINFO_EXTENSION);
                $filename = 'profile_' . $_SESSION['user_id'] . '_' . time() . '.' . $extension;
                $uploadPath = PROFILE_PATH . '/' . $filename;
                
                if (move_uploaded_file($file['tmp_name'], $uploadPath)) {
                    // Delete old photo if exists
                    if ($user['profile_photo'] && file_exists(PROFILE_PATH . '/' . $user['profile_photo'])) {
                        unlink(PROFILE_PATH . '/' . $user['profile_photo']);
                    }
                    
                    if ($auth->updateProfilePhoto($filename)) {
                        $success = 'Foto profil berhasil diperbarui!';
                        $user = $auth->getCurrentUser(); // Refresh user data
                    } else {
                        $error = 'Gagal menyimpan foto profil!';
                    }
                } else {
                    $error = 'Gagal mengupload foto!';
                }
            } else {
                $error = 'Format file tidak didukung! Gunakan JPG, JPEG, atau PNG.';
            }
        } else {
            $error = 'Pilih file foto terlebih dahulu!';
        }
    }
    
    if (isset($_POST['change_password'])) {
        // Change password
        $currentPassword = $_POST['current_password'];
        $newPassword = $_POST['new_password'];
        $confirmPassword = $_POST['confirm_password'];
        
        if (empty($currentPassword) || empty($newPassword) || empty($confirmPassword)) {
            $error = 'Semua field password harus diisi!';
        } elseif ($newPassword !== $confirmPassword) {
            $error = 'Konfirmasi password tidak cocok!';
        } elseif (strlen($newPassword) < 6) {
            $error = 'Password minimal 6 karakter!';
        } else {
            if ($auth->changePassword($currentPassword, $newPassword)) {
                $success = 'Password berhasil diubah!';
            } else {
                $error = 'Password lama tidak benar!';
            }
        }
    }
}

$title = 'Profil - SMAN 1 Tanjungbalai';
$showNavbar = true;
$showSidebar = true;

include '../resources/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h1 class="h3 mb-0 fw-bold">Profil Pengguna</h1>
        <p class="text-muted mb-0">Kelola informasi profil Anda</p>
    </div>
</div>

<?php if ($error): ?>
    <div class="alert alert-danger" role="alert">
        <i class="fas fa-exclamation-triangle me-2"></i><?php echo $error; ?>
    </div>
<?php endif; ?>

<?php if ($success): ?>
    <div class="alert alert-success" role="alert">
        <i class="fas fa-check-circle me-2"></i><?php echo $success; ?>
    </div>
<?php endif; ?>

<div class="row">
    <!-- Profile Photo Card -->
    <div class="col-lg-4 mb-4">
        <div class="card">
            <div class="card-header bg-white">
                <h6 class="mb-0 fw-bold">Foto Profil</h6>
            </div>
            <div class="card-body text-center">
                <div class="mb-3">
                    <?php if ($user['profile_photo']): ?>
                        <img src="../uploads/profiles/<?php echo $user['profile_photo']; ?>" 
                             alt="Profile" class="rounded-circle profile-img">
                    <?php else: ?>
                        <div class="rounded-circle profile-img bg-light d-flex align-items-center justify-content-center mx-auto">
                            <i class="fas fa-user fa-3x text-muted"></i>
                        </div>
                    <?php endif; ?>
                </div>
                
                <form method="POST" enctype="multipart/form-data">
                    <div class="mb-3">
                        <input type="file" class="form-control" name="profile_photo" accept="image/*" required>
                        <small class="text-muted">Format: JPG, JPEG, PNG. Ukuran maksimal: 2MB</small>
                    </div>
                    <button type="submit" name="upload_photo" class="btn btn-primary">
                        <i class="fas fa-upload me-1"></i>Upload Foto
                    </button>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Profile Information -->
    <div class="col-lg-8 mb-4">
        <div class="card">
            <div class="card-header bg-white">
                <h6 class="mb-0 fw-bold">Informasi Profil</h6>
            </div>
            <div class="card-body">
                <form method="POST" class="needs-validation" novalidate>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="full_name" class="form-label">Nama Lengkap</label>
                            <input type="text" class="form-control" id="full_name" name="full_name" 
                                   value="<?php echo $user['full_name']; ?>" required>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" class="form-control" id="email" name="email" 
                                   value="<?php echo $user['email']; ?>" required>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="nip" class="form-label">NIP</label>
                            <input type="text" class="form-control" id="nip" name="nip" 
                                   value="<?php echo $user['nip']; ?>">
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="position" class="form-label">Jabatan</label>
                            <input type="text" class="form-control" id="position" name="position" 
                                   value="<?php echo $user['position']; ?>" required>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="birth_place" class="form-label">Tempat Lahir</label>
                            <input type="text" class="form-control" id="birth_place" name="birth_place" 
                                   value="<?php echo $user['birth_place']; ?>">
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="birth_date" class="form-label">Tanggal Lahir</label>
                            <input type="date" class="form-control" id="birth_date" name="birth_date" 
                                   value="<?php echo $user['birth_date']; ?>">
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="education" class="form-label">Pendidikan Terakhir</label>
                            <input type="text" class="form-control" id="education" name="education" 
                                   value="<?php echo $user['education']; ?>">
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="phone" class="form-label">Telepon</label>
                            <input type="text" class="form-control" id="phone" name="phone" 
                                   value="<?php echo $user['phone']; ?>">
                        </div>
                        
                        <div class="col-12 mb-3">
                            <label for="address" class="form-label">Alamat</label>
                            <textarea class="form-control" id="address" name="address" rows="3"><?php echo $user['address']; ?></textarea>
                        </div>
                    </div>
                    
                    <button type="submit" name="update_profile" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i>Simpan Perubahan
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Change Password Card -->
<div class="row">
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header bg-white">
                <h6 class="mb-0 fw-bold">Ubah Password</h6>
            </div>
            <div class="card-body">
                <form method="POST" class="needs-validation" novalidate>
                    <div class="mb-3">
                        <label for="current_password" class="form-label">Password Lama</label>
                        <input type="password" class="form-control" id="current_password" name="current_password" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="new_password" class="form-label">Password Baru</label>
                        <input type="password" class="form-control" id="new_password" name="new_password" 
                               minlength="6" required>
                        <small class="text-muted">Minimal 6 karakter</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="confirm_password" class="form-label">Konfirmasi Password Baru</label>
                        <input type="password" class="form-control" id="confirm_password" name="confirm_password" 
                               minlength="6" required>
                    </div>
                    
                    <button type="submit" name="change_password" class="btn btn-warning">
                        <i class="fas fa-key me-1"></i>Ubah Password
                    </button>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Developer Info Card -->
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header bg-white">
                <h6 class="mb-0 fw-bold">Tentang Pengembang</h6>
            </div>
            <div class="card-body">
                <div class="d-flex align-items-center mb-3">
                    <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center me-3" 
                         style="width: 60px; height: 60px;">
                        <i class="fas fa-code fa-2x"></i>
                    </div>
                    <div>
                        <h6 class="mb-0 fw-bold">T. Rifaldo Sany</h6>
                        <small class="text-muted">Pustakawan Junior SMAN 1 Tanjungbalai</small>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-12 mb-2">
                        <small class="text-muted">NIP:</small><br>
                        <span>-</span>
                    </div>
                    
                    <div class="col-12 mb-2">
                        <small class="text-muted">Tempat, Tanggal Lahir:</small><br>
                        <span>Tanjung Balai, 22 Mei 2024</span>
                    </div>
                    
                    <div class="col-12 mb-2">
                        <small class="text-muted">Pendidikan Terakhir:</small><br>
                        <span>S1 Ilmu Perpustakaan (Masa Pendidikan)</span>
                    </div>
                    
                    <div class="col-12 mb-2">
                        <small class="text-muted">Email:</small><br>
                        <span>t.rifaldosany@gmail.com</span>
                    </div>
                    
                    <div class="col-12">
                        <small class="text-muted">Telepon:</small><br>
                        <span>+62 857-6777-6154</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Password confirmation validation
document.getElementById('confirm_password').addEventListener('input', function() {
    const newPassword = document.getElementById('new_password').value;
    const confirmPassword = this.value;
    
    if (newPassword !== confirmPassword) {
        this.setCustomValidity('Password tidak cocok');
    } else {
        this.setCustomValidity('');
    }
});
</script>

<?php include '../resources/footer.php'; ?>

